#region References

using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using gov.va.med.vbecs.BOL;
using gov.va.med.vbecs.GUI.controls;

#endregion

namespace gov.va.med.vbecs.GUI
{
	/// <summary>
	/// Class FrmFreeDirectedUnit
	/// </summary>
	public class FrmFreeDirectedUnit : gov.va.med.vbecs.GUI.VbecsBaseForm
	{
		#region Variables

		private static string _baseMessage = Common.StrRes.InfoMsg.UC071.NotEligible().ResString;
		private static string _separator = ". ";

		private static Common.WorkloadProcessID _workloadProcessId = Common.WorkloadProcessID.ReleaseDirectedUnit;

		private BloodUnit _bloodUnit;
		private VbecsUser [] _userArray;
		private Guid _bloodUnitGUID;
		private ArrayList _comments;
		private bool _detailsRequired = false;
		private bool _unitSelectedFromSearch = false;

		#endregion

		#region Form Controls

		private System.Windows.Forms.Button btnCancel;
		private gov.va.med.vbecs.GUI.controls.VbecsButton btnOK;
		private gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical bloodUnitSelectorVertical1;
		private gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab bloodUnitDetailsTab1;
		private System.Windows.Forms.GroupBox grpRemoveRestriction;
		private System.Windows.Forms.Label lblRemovedBy;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbRemovedBy;
		private System.Windows.Forms.DateTimePicker dtpDateRemoved;
		private System.Windows.Forms.Label lblDateRemoved;
		private System.Windows.Forms.Label lblComment;
		private gov.va.med.vbecs.GUI.controls.ComboBoxLookup cmbComment;
		private System.Windows.Forms.Label lblDetails;
		private System.Windows.Forms.TextBox txtDetails;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox picImage;
		private System.ComponentModel.IContainer components = null;

		#endregion

		#region Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(FrmFreeDirectedUnit));
			this.grpRemoveRestriction = new System.Windows.Forms.GroupBox();
			this.txtDetails = new System.Windows.Forms.TextBox();
			this.lblDetails = new System.Windows.Forms.Label();
			this.lblComment = new System.Windows.Forms.Label();
			this.cmbComment = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.lblRemovedBy = new System.Windows.Forms.Label();
			this.cmbRemovedBy = new gov.va.med.vbecs.GUI.controls.ComboBoxLookup(this.components);
			this.dtpDateRemoved = new System.Windows.Forms.DateTimePicker();
			this.lblDateRemoved = new System.Windows.Forms.Label();
			this.btnOK = new gov.va.med.vbecs.GUI.controls.VbecsButton();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.picImage = new System.Windows.Forms.PictureBox();
			this.btnCancel = new System.Windows.Forms.Button();
			this.bloodUnitSelectorVertical1 = new gov.va.med.vbecs.GUI.controls.BloodUnitSelectorVertical();
			this.bloodUnitDetailsTab1 = new gov.va.med.vbecs.GUI.controls.BloodUnitDetailsTab();
			this.grpRemoveRestriction.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// vbecsLogo1
			// 
			this.vbecsLogo1.Name = "vbecsLogo1";
			this.vbecsLogo1.Size = new System.Drawing.Size(592, 30);
			this.vbecsLogo1.TabIndex = 5;
			this.vbecsLogo1.Title = "Free Directed Unit For Crossover";
			// 
			// lblRequiredField
			// 
			this.lblRequiredField.Location = new System.Drawing.Point(0, 356);
			this.lblRequiredField.Name = "lblRequiredField";
			this.lblRequiredField.TabIndex = 7;
			// 
			// grpRemoveRestriction
			// 
			this.grpRemoveRestriction.AccessibleDescription = "Remove Restriction";
			this.grpRemoveRestriction.AccessibleName = "Remove Restriction";
			this.grpRemoveRestriction.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpRemoveRestriction.Controls.Add(this.txtDetails);
			this.grpRemoveRestriction.Controls.Add(this.lblDetails);
			this.grpRemoveRestriction.Controls.Add(this.lblComment);
			this.grpRemoveRestriction.Controls.Add(this.cmbComment);
			this.grpRemoveRestriction.Controls.Add(this.lblRemovedBy);
			this.grpRemoveRestriction.Controls.Add(this.cmbRemovedBy);
			this.grpRemoveRestriction.Controls.Add(this.dtpDateRemoved);
			this.grpRemoveRestriction.Controls.Add(this.lblDateRemoved);
			this.grpRemoveRestriction.Location = new System.Drawing.Point(324, 188);
			this.grpRemoveRestriction.Name = "grpRemoveRestriction";
			this.grpRemoveRestriction.Size = new System.Drawing.Size(264, 148);
			this.grpRemoveRestriction.TabIndex = 2;
			this.grpRemoveRestriction.TabStop = false;
			this.grpRemoveRestriction.Text = "Remove Restriction";
			// 
			// txtDetails
			// 
			this.txtDetails.AccessibleDescription = "details";
			this.txtDetails.AccessibleName = "details";
			this.txtDetails.Anchor = ((System.Windows.Forms.AnchorStyles)((((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtDetails.ReadOnly = true;
			this.txtDetails.Location = new System.Drawing.Point(88, 88);
			this.txtDetails.Multiline = true;
			this.txtDetails.Name = "txtDetails";
			this.txtDetails.Size = new System.Drawing.Size(164, 52);
			this.txtDetails.TabIndex = 7;
			this.txtDetails.Text = "";
			this.txtDetails.TextChanged += new System.EventHandler(this.txtDetails_TextChanged);
			// 
			// lblDetails
			// 
			this.lblDetails.Location = new System.Drawing.Point(8, 88);
			this.lblDetails.Name = "lblDetails";
			this.lblDetails.Size = new System.Drawing.Size(72, 20);
			this.lblDetails.TabIndex = 6;
			this.lblDetails.Text = "Details";
			this.lblDetails.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblComment
			// 
			this.lblComment.Location = new System.Drawing.Point(8, 64);
			this.lblComment.Name = "lblComment";
			this.lblComment.Size = new System.Drawing.Size(72, 20);
			this.lblComment.TabIndex = 4;
			this.lblComment.Text = "Comment*";
			this.lblComment.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbComment
			// 
			this.cmbComment.AccessibleDescription = "comment";
			this.cmbComment.AccessibleName = "comment";
			this.cmbComment.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbComment.Enabled = false;
			this.cmbComment.Interval = 100;
			this.cmbComment.Location = new System.Drawing.Point(88, 64);
			this.cmbComment.Name = "cmbComment";
			this.cmbComment.Size = new System.Drawing.Size(164, 22);
			this.cmbComment.TabIndex = 5;
			this.cmbComment.SelectedIndexChanged += new System.EventHandler(this.cmbComment_SelectedIndexChanged);
			// 
			// lblRemovedBy
			// 
			this.lblRemovedBy.Location = new System.Drawing.Point(8, 40);
			this.lblRemovedBy.Name = "lblRemovedBy";
			this.lblRemovedBy.Size = new System.Drawing.Size(76, 20);
			this.lblRemovedBy.TabIndex = 2;
			this.lblRemovedBy.Text = "Removed By*";
			this.lblRemovedBy.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// cmbRemovedBy
			// 
			this.cmbRemovedBy.AccessibleDescription = "Removed By";
			this.cmbRemovedBy.AccessibleName = "Removed By";
			this.cmbRemovedBy.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.cmbRemovedBy.Enabled = false;
			this.cmbRemovedBy.Interval = 100;
			this.cmbRemovedBy.Location = new System.Drawing.Point(88, 40);
			this.cmbRemovedBy.Name = "cmbRemovedBy";
			this.cmbRemovedBy.Size = new System.Drawing.Size(164, 22);
			this.cmbRemovedBy.TabIndex = 3;
			this.cmbRemovedBy.SelectedIndexChanged += new System.EventHandler(this.cmbRemovedBy_SelectedIndexChanged);
			// 
			// dtpDateRemoved
			// 
			this.dtpDateRemoved.AccessibleDescription = "Date Removed";
			this.dtpDateRemoved.AccessibleName = "Date Removed";
			this.dtpDateRemoved.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.dtpDateRemoved.Enabled = false;
			this.dtpDateRemoved.Format = System.Windows.Forms.DateTimePickerFormat.Custom;
			this.dtpDateRemoved.Location = new System.Drawing.Point(88, 16);
			this.dtpDateRemoved.Name = "dtpDateRemoved";
			this.dtpDateRemoved.Size = new System.Drawing.Size(164, 20);
			this.dtpDateRemoved.TabIndex = 1;
			// 
			// lblDateRemoved
			// 
			this.lblDateRemoved.Location = new System.Drawing.Point(8, 16);
			this.lblDateRemoved.Name = "lblDateRemoved";
			this.lblDateRemoved.Size = new System.Drawing.Size(84, 20);
			this.lblDateRemoved.TabIndex = 0;
			this.lblDateRemoved.Text = "Date Removed*";
			this.lblDateRemoved.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// btnOK
			// 
			this.btnOK.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnOK.Enabled = false;
			this.btnOK.EnabledButton = false;
			this.btnOK.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.btnOK.Image = ((System.Drawing.Image)(resources.GetObject("btnOK.Image")));
			this.btnOK.Location = new System.Drawing.Point(432, 340);
			this.btnOK.Name = "btnOK";
			this.btnOK.Size = new System.Drawing.Size(75, 23);
			this.btnOK.TabIndex = 3;
			this.btnOK.Click += new System.EventHandler(this.btnOK_Click);
			this.btnOK.MouseHover += new System.EventHandler(this.btnOK_MouseHover);
			// 
			// grpImage
			// 
			this.grpImage.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.grpImage.Controls.Add(this.picImage);
			this.grpImage.Location = new System.Drawing.Point(4, 32);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(52, 304);
			this.grpImage.TabIndex = 6;
			this.grpImage.TabStop = false;
			// 
			// picImage
			// 
			this.picImage.Image = ((System.Drawing.Image)(resources.GetObject("picImage.Image")));
			this.picImage.Location = new System.Drawing.Point(4, 12);
			this.picImage.Name = "picImage";
			this.picImage.Size = new System.Drawing.Size(45, 45);
			this.picImage.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picImage.TabIndex = 0;
			this.picImage.TabStop = false;
			// 
			// btnCancel
			// 
			this.btnCancel.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.btnCancel.CausesValidation = false;
			this.btnCancel.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.btnCancel.Location = new System.Drawing.Point(512, 340);
			this.btnCancel.Name = "btnCancel";
			this.btnCancel.TabIndex = 4;
			this.btnCancel.Text = "&Cancel";
			this.btnCancel.Click += new System.EventHandler(this.btnCancel_Click);
			// 
			// bloodUnitSelectorVertical1
			// 
			this.bloodUnitSelectorVertical1.AdditionalSearchCriteria = gov.va.med.vbecs.Common.AdditionalBloodUnitSearchCriteria.None;
			this.bloodUnitSelectorVertical1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Bottom) 
				| System.Windows.Forms.AnchorStyles.Left)));
			this.bloodUnitSelectorVertical1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitSelectorVertical1.Location = new System.Drawing.Point(60, 32);
			this.bloodUnitSelectorVertical1.Name = "bloodUnitSelectorVertical1";
			this.bloodUnitSelectorVertical1.Size = new System.Drawing.Size(258, 308);
			this.bloodUnitSelectorVertical1.TabIndex = 0;
			this.bloodUnitSelectorVertical1.SearchBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_SearchBtnClick);
			this.bloodUnitSelectorVertical1.UnitUpdated += new System.EventHandler(this.bloodUnitSelectorVertical1_UnitUpdated);
			this.bloodUnitSelectorVertical1.ClearBtnClick += new System.EventHandler(this.bloodUnitSelectorVertical1_ClearBtnClick);
			// 
			// bloodUnitDetailsTab1
			// 
			this.bloodUnitDetailsTab1.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.bloodUnitDetailsTab1.BloodUnit = null;
			this.bloodUnitDetailsTab1.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.bloodUnitDetailsTab1.Location = new System.Drawing.Point(324, 36);
			this.bloodUnitDetailsTab1.Name = "bloodUnitDetailsTab1";
			this.bloodUnitDetailsTab1.Size = new System.Drawing.Size(264, 148);
			this.bloodUnitDetailsTab1.TabIndex = 1;
			// 
			// FrmFreeDirectedUnit
			// 
			this.AcceptButton = this.btnOK;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.btnCancel;
			this.ClientSize = new System.Drawing.Size(592, 372);
			this.Controls.Add(this.bloodUnitDetailsTab1);
			this.Controls.Add(this.bloodUnitSelectorVertical1);
			this.Controls.Add(this.grpImage);
			this.Controls.Add(this.btnCancel);
			this.Controls.Add(this.btnOK);
			this.Controls.Add(this.grpRemoveRestriction);
			this.hlphelpChm.SetHelpKeyword(this, "Free_Directed_Unit_For_Crossover.htm");
			this.hlphelpChm.SetHelpNavigator(this, System.Windows.Forms.HelpNavigator.Topic);
			this.MinimumSize = new System.Drawing.Size(600, 399);
			this.Name = "FrmFreeDirectedUnit";
			this.RequiredFieldsLabel = true;
			this.hlphelpChm.SetShowHelp(this, true);
			this.Text = "VBECS - Free Directed Unit For Crossover";
			this.Load += new System.EventHandler(this.FrmFreeDirectedUnit_Load);
			this.KeyDownSpeakMessage += new gov.va.med.vbecs.GUI.VbecsBaseForm.KeyDownSpeakMessageEventHandler(this.FrmFreeDirectedUnit_KeyDownSpeakMessage);
			this.Controls.SetChildIndex(this.grpRemoveRestriction, 0);
			this.Controls.SetChildIndex(this.btnOK, 0);
			this.Controls.SetChildIndex(this.btnCancel, 0);
			this.Controls.SetChildIndex(this.grpImage, 0);
			this.Controls.SetChildIndex(this.bloodUnitSelectorVertical1, 0);
			this.Controls.SetChildIndex(this.bloodUnitDetailsTab1, 0);
			this.Controls.SetChildIndex(this.vbecsLogo1, 0);
			this.Controls.SetChildIndex(this.lblRequiredField, 0);
			this.grpRemoveRestriction.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get Comment
		/// </summary>
		private string Comment
		{
			get 
			{	
				string comment = string.Empty;
				//
				if (this.cmbComment.SelectedIndex > -1)
				{
					if (this._detailsRequired)
					{
						comment	= this.txtDetails.Text;
					}
					else
					{
						comment = this.cmbComment.Text;
						//
						if (this.txtDetails.Text.Trim().Length > 0)
						{
							comment = string.Concat(comment, _separator, this.txtDetails.Text);
						}
					}
				}
				return comment;	
			}
		}

		#endregion

		#region Constructors / Dispose

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		/// <summary>
		/// Constructor
		/// </summary>
		public FrmFreeDirectedUnit()
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			LoadCannedComments();
		}

		/// <summary>
		/// Constructor - with Bloodunit
		/// Created 5/10/2005 - Lohse - For Alternate Flow D, UC24
		/// </summary>
		/// <param name="originalUnit"></param>
		public FrmFreeDirectedUnit(BOL.BloodUnit originalUnit)
		{
			// This call is required by the Windows Form Designer.
			InitializeComponent();

			SetComponentProperties();

			LoadCannedComments();

			this._unitSelectedFromSearch = false;

			if (this.SetLocks(originalUnit.BloodUnitMedia.BloodUnitMediaGuid, originalUnit.BloodUnitGuid))
			{						
				this.bloodUnitSelectorVertical1.DisplayBloodUnit(originalUnit);
			}
		}


		#endregion

		#region Methods

		/// <summary>
		/// CheckIfDetailsRequired
		/// </summary>
		private void CheckIfDetailsRequired()
		{
			// Details required if Comment = Other
			if (this.cmbComment.Text.Trim().ToUpper().Equals("OTHER"))
			{
				this.lblDetails.Text = "Details*";
				this._detailsRequired = true;
			}
			else
			{
				this.lblDetails.Text = "Details";
				this._detailsRequired = false;
			}
		}

		/// <summary>
		/// CheckValid
		/// </summary>
		private bool CheckValid()
		{
			if (_detailsRequired)
			{
				return (this.txtDetails.Text.Trim().Length > 0);
			}
			else
			{
				return (this.cmbComment.SelectedIndex > - 1);
			}
		}

		/// <summary>
		/// ClearControls
		/// </summary>
		private void ClearControls()
		{
			this.txtDetails.Text = "";
			this.cmbComment.SelectedIndex = -1;
			this.cmbRemovedBy.SelectedIndex = -1;

			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = false;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = false;

			bloodUnitDetailsTab1.BloodUnit = null;
			bloodUnitDetailsTab1.Refresh();

			this._unitSelectedFromSearch = false;

			SetRemovalDetailsEnabled(false);
		}

		/// <summary>
		/// GetBloodUnit
		/// </summary>
		private void GetBloodUnit()
		{
			this._bloodUnitGUID = this.bloodUnitSelectorVertical1.SelectedBloodUnit.BloodUnitGuid;
			this._bloodUnit = new BOL.BloodUnit(this._bloodUnitGUID);
		}

		/// <summary>
		/// LoadCannedComments
		/// </summary>
		private void LoadCannedComments()
		{
			_comments = BOL.CannedComment.GetCannedCommentsList(Common.LogonUser.LogonUserDivisionCode, "UX");
			
			this.cmbComment.Items.Clear();

			foreach(Hashtable table in _comments)
			{
				this.cmbComment.Items.Add(table[Common.VbecsTables.CannedComment.CannedCommentText]);
			}
		}

		/// <summary>
		/// PopulateControls
		/// </summary>
		private void PopulateControls()
		{
			dtpDateRemoved.MaxDate = VBECSDateTime.GetDivisionCurrentDateTime();

			this.txtDetails.Text = "";
			this.cmbComment.SelectedIndex = -1;
			this.bloodUnitSelectorVertical1.txtProductID.ReadOnly = true;
			this.bloodUnitSelectorVertical1.txtUnitID.ReadOnly = true;

			bloodUnitDetailsTab1.BloodUnit = this._bloodUnit;
			bloodUnitDetailsTab1.Refresh();

			if (this._userArray == null || this._userArray.Length < 1)
			{
				ArrayList userList = BOL.VbecsUser.GetActiveDivisionUsers( Common.LogonUser.LogonUserDivisionCode );
				this._userArray = new BOL.VbecsUser[userList.Count];

				int index = 0;
				foreach (BOL.VbecsUser currentUser in userList)
				{
					cmbRemovedBy.Items.Add(currentUser.UserName);
					this._userArray[index++] = currentUser;
				}
				//
				this.cmbRemovedBy.Text = ThisUser.UserName;
			}
		}

		/// <summary>
		/// SetComponentProperties
		/// </summary>
		private void SetComponentProperties()
		{
            this.LockController.LockFunction = Common.LockFunctions.UC071FreeDirectedUnitForCrossover;

			this.vbecsLogo1.Title = "Free Directed Unit";
			// CR 2693
			// hlpHelp
			// 
			this.hlpHelp.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			// 
			// hlphelpChm
			// 
			this.hlphelpChm.HelpNamespace = Environment.CurrentDirectory+"\\VBECS.chm";
			//
			this.SetThisHelpFile(this, Common.StrRes.HelpFiles.UC071.FrmFreeDirectedUnit());

			//set custom date and time format
			this.dtpDateRemoved.CustomFormat = Common.VBECSDateTime.DateTimeFormat;

			//set current date value based on the division time zone
			this.dtpDateRemoved.Value = BOL.VBECSDateTime.GetDivisionCurrentDateTime();
		}

		/// <summary>
		///
		/// </summary>
		private void SetRemovalDetailsEnabled(bool enabled)
		{
			dtpDateRemoved.Enabled = enabled;
			cmbRemovedBy.Enabled = enabled;
			cmbComment.Enabled = enabled;
			txtDetails.ReadOnly = !enabled;
			btnOK.Enabled = enabled;
		}

		/// <summary>
		/// Checks form data/controlls to see 
		/// if okay for submission.
		/// </summary>
		private void ValidateFormData()
		{
			this.CheckIfDetailsRequired();

			if (this.CheckValid() && cmbRemovedBy.SelectedIndex > -1 && !cmbRemovedBy.SelectedItem.ToString().Equals(string.Empty))
			{
				btnOK.Enabled = true;
				btnOK.EnabledButton = true;
			}
			else
			{
				btnOK.Enabled = false;
				btnOK.EnabledButton = false;
			}
		}

		#endregion

		#region Events


		/// <summary>
		/// bloodUnitSelectorVertical1_ClearBtnClick Event Handler
		/// </summary>
		private void bloodUnitSelectorVertical1_ClearBtnClick(object sender, System.EventArgs e)
		{
			this.UnlockAllRecords();
			this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
			this.ClearControls();
			this.IsDirty = false;
		}

		/// <summary>
		/// bloodUnitSelectorVertical1_SearchBtnClick Event Handler
		/// </summary>
		private void bloodUnitSelectorVertical1_SearchBtnClick(object sender, System.EventArgs e)
		{
			using (new WaitCursor()) 
			{
				try
				{
					this.Working();
			
					DlgSelectBloodUnits unitSelector = new DlgSelectBloodUnits(BloodUnit.GetBloodUnitsEligibleForCrossover(), this.bloodUnitSelectorVertical1.EnteredEyeReadableUnitId, this.bloodUnitSelectorVertical1.EnteredUnitProductCode);
					unitSelector.MultiSelect = false;
					unitSelector.TitleBarText = "VBECS - Select Directed Unit";
					unitSelector.LogoBarText = "Select Directed Unit";

					unitSelector.ShowDialogFromLockedParent(this,false);
					
					if (unitSelector.DialogResult == DialogResult.OK)
					{
						this._unitSelectedFromSearch = true;
						System.Data.DataRow dr = unitSelector.SelectedUnits.Rows[0];

						BOL.BloodUnit lockUnit = new BOL.BloodUnit((System.Guid)dr[Common.VbecsTables.BloodUnit.BloodUnitGuid]);
						if (this.SetLocks(lockUnit.BloodUnitMedia.BloodUnitMediaGuid, lockUnit.BloodUnitGuid))
						{						
							this.bloodUnitSelectorVertical1.DisplayBloodUnit(dr[Common.VbecsTables.BloodUnit.EyeReadableUnitId].ToString(), dr[Common.DatabaseConstants.ArtificialColumnNames.FullProductCode].ToString());
						}
					}
				}
				catch (Exception err)
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.CannotCreateSearchTool(err.Message));
				}
				finally
				{
					this.Ready();
				}
			}
		}

		/// <summary>
		/// bloodUnitSelectorVertical1_UnitUpdated Event Handler
		/// </summary>
		private void bloodUnitSelectorVertical1_UnitUpdated(object sender, System.EventArgs e)
		{
			try
			{
				this.GetBloodUnit();
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, String.Empty); // **** 508 Compliance ***
				
				if (!this.SetLocks(this._bloodUnit.BloodUnitMedia.BloodUnitMediaGuid, this._bloodUnit.BloodUnitGuid))
					return;

				// If the user selected the unit from the list, this means
				// the unit is already in compliance with the business rules,
				// enforced through the DAL and stored procedure.  Otherwise, 
				// if he/she entered the Unit ID and Product Codes or scanned
				// them in, then we need to verify the unit is eligible.
				if (!this._unitSelectedFromSearch)
				{
					StringBuilder messages = new StringBuilder(_baseMessage);
					messages.Append(this._bloodUnit.IsEligibleForCrossover());
					if (messages.Length != _baseMessage.Length)
					{
						// details will not be loaded if unit is not eligible
						throw new BOL.BusinessObjectException(messages.ToString());
					}
				}

				this.PopulateControls();

				// allow user to free restriction
				SetRemovalDetailsEnabled(true);
			}
			catch(Exception err)
			{
				this.errError.SetVbecsError(this.bloodUnitSelectorVertical1.txtProductID, err.Message); // **** 508 Compliance ***
			}
		}

		/// <summary>
		/// btnCancel_Click Event Handler
		/// </summary>
		private void btnCancel_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}

		/// <summary>
		/// btnOK_Click Event Handler
		/// </summary>
		private void btnOK_Click(object sender, System.EventArgs e)
		{
			DialogResult saveResult = GuiMessenger.ShowMessageBox(Common.StrRes.ConfMsg.UC071.RemoveRestriction());
			if (saveResult == DialogResult.Yes)
			{
				
				if (this._bloodUnit.FreeDirectedBloodUnit(this._userArray[cmbRemovedBy.SelectedIndex].UserNTLoginID, dtpDateRemoved.Value, this.Comment, _workloadProcessId))
				{
					//CR 1441
					System.Data.DataTable dt  = BOL.WorkloadEvent.GetWorkloadProcessGuidByProcessID((int) _workloadProcessId);
					if(dt!= null && _workloadProcessId != Common.WorkloadProcessID.Unknown)
					{
						if(dt.Rows.Count == 0)
						{
							GuiMessenger.ShowMessageBox(Common.StrRes.InfoMsg.UC015.BR1502_NoWorkloadDefined());
						}
					}
					this.DialogResult = DialogResult.OK;
					this.IsDirty = false;
					this.Close();
				}
				else
				{
					GuiMessenger.ShowMessageBox(Common.StrRes.SysErrMsg.Common.DataNotSaved("blood unit restriction"));
					return;
				}
			}
		}

		/// <summary>
		/// FrmFreeDirectedUnit_Load Event Handler
		/// </summary>
		private void FrmFreeDirectedUnit_Load(object sender, System.EventArgs e)
		{
			this.IsDirty = false;
		}

		/// <summary>
		/// btnOK_MouseHover Event Handler
		/// </summary>
		private void btnOK_MouseHover(object sender, System.EventArgs e)
		{
			if (this.btnOK.EnabledButton)
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.UC071.RemoveRestriction().ResString);
			}
			else
			{
				this.btnOK.SetToolTip(Common.StrRes.Tooltips.Common.EnterAComment().ResString);
			}
		}

		/// <summary>
		/// cmbComment_SelectedIndexChanged Event Handler
		/// </summary>
		private void cmbComment_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (cmbComment.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// cmbRemovedBy_SelectedIndexChanged Event Handler
		/// </summary>
		private void cmbRemovedBy_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (cmbRemovedBy.SelectedIndex > -1)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		///
		/// </summary>
		private void txtDetails_TextChanged(object sender, System.EventArgs e)
		{
			ValidateFormData();

			if (txtDetails.Text.Trim().Length > 0)
			{
				this.SetDirtyFlag(sender, e);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void FrmFreeDirectedUnit_KeyDownSpeakMessage(object sender, EventArgs e)
		{
			string textToSpeak = string.Empty;
			//
			
			//
			// Also get the error provider messages for the BloodUnitSelector control
			textToSpeak = string.Concat(textToSpeak, "\n", this.bloodUnitSelectorVertical1.GetErrorMessages());
			if ( this.errError != null )
			{
				
				if(this.errError.GetErrorMessages().Trim().Length == 0)
				{
					textToSpeak = this._bloodUnit != null && !this.btnOK.EnabledButton ? Common.StrRes.Tooltips.Common.EnterAComment().ResString : null;
				}
			}
			else
			{
				textToSpeak = this._bloodUnit != null && !this.btnOK.EnabledButton ? Common.StrRes.Tooltips.Common.EnterAComment().ResString : null;
			}
			this.SpeakMessage( textToSpeak );
		}

		#endregion
	}
}

